import React, { Component } from 'react';
import { View, Button, TextInput, Alert } from 'react-native';
const initialState = { name: '', job: '' };
class Form extends Component {
    constructor(props) {
        super(props);
        this.state = initialState;
    }
    onChangeNameText = text => {
        this.setState({ name: text });
    };
    onChangeJobText = text => {
        this.setState({ job: text });
    };
    submitForm = () => {
        const { name, job } = this.state;
        if (name.length > 0 && job.length > 0) {
            this.props.addItem(this.state);
            this.setState(initialState);
        } else {
            Alert.alert('Please enter data!!');
        }
    };
    render() {
        const { name, job } = this.state;
        return (
            <View>
                <TextInput
                    placeholder="Your name"
                    maxLength={20}
                    onChangeText={this.onChangeNameText}
                    value={name}
                />
                <TextInput
                    placeholder="Your job"
                    maxLength={20}
                    onChangeText={this.onChangeJobText}
                    value={job}
                />
                <Button onPress={this.submitForm} title="Submit" />
            </View>
        );
    }
}
export default Form;